<?php
   /*
    *
    * copyright (c) 2013-2024 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * Questa classe consente di fare vari tipi di controlli per verificare la presenza di codice html,
    * link, mysql e altro ancora con il metodo base rilevaElemento
    */

    class ControlloreStringhe {

        public static function rilevaHtml($testo) {
            $paroleDaRilevare = array("<html>","%8Bhtml%9B","%3Chtml%3E","<body>","%8Bbody%9B","%3Cbody%3E","<img>","%8Bimg%9B","%3Cimg%3E","<div>","%8Bdiv%9B","%3Cdiv%3E","<iframe>","%8Biframe%9B","%3Ciframe%3E");
            return ControlloreStringhe::rilevaElemento($testo, $paroleDaRilevare);
        }
        
        public static function rilevaJavascript($testo) {
            if(strpos($testo,"<script>")>-1 || strpos($testo,"%8Bscript%9B")>-1  || strpos($testo,"%3Cscript%3E")>-1 || strpos($testo,"location.href")>-1) { 
                return true;
            }
            else {
                return false;
            }
        }
        
        public static function rilevaMysql($testo) {
            if(strpos($testo,"INSERT")>-1 || strpos($testo,"SELECT")>-1 || strpos($testo,"DELETE")>-1) {
                return true;
            }
            else {
                return false;
            }
        }
        
        /*
         * rileva un link sia con il tag html a che scrivendo le parole 
         */
        public static function rilevaLink($testo) {
            $paroleDaRilevare = array("<a>","%8Ba%9B","%3Ca%3E","http","https","www.");
            return ControlloreStringhe::rilevaElemento($testo, $paroleDaRilevare);
        }
        
        /*
         * metodo base che prende in input un array e una stringa di testo e cerca le stringhe 
         * presenti nell'array all'interno del testo
         */
        public static function rilevaElemento($testo,$arrayParole) {
            $trovato = false;
            foreach($arrayParole as $parola) {
                if(strpos($testo,$parola)>-1) {
                    $trovato = true;
                    break;
                }
            }
            return $trovato;
        }
        
        /*
         * qusto metodo prende in input una stringa e restituisce una nuova stringa senza carateri
         * speciali
         */
        public static function rimuoviCaratteriSpeciali($stringa) {
            $nuovaStringa = str_replace(' ', '-', $stringa); //sostitusie gli spazi con un -
            return preg_replace('/[^A-Za-z0-9\-]/', '', $nuovaStringa); //elimina tutti i caratteri diversi da lettere, numeri e -
        }
    }
